﻿/*
 * Class TwitterBadge.as
 * @author Sam Wilson (http://www.storypixel.com)
 * 
 * @desc A simple class which shows how to get your Tweets in the simplest way. I don't offer support/guidance
 * on any of this, but feel free use to like you want: free as in beer and speech.
 */

package com.twitter {
	import flash.text.AntiAliasType;	
	import flash.text.TextFieldAutoSize;	
	import flash.text.TextField;	

	import com.twitter.api.data.TwitterStatus;	
	import com.twitter.api.events.TwitterEvent;	
	import com.twitter.api.Twitter;	

	import flash.display.Sprite;	

	
	
	public class TwitterBadge extends Sprite {
		
		private var username : String = "matthbooth"; // CHANGE THIS TO YUOR USERNAME
		
		private var twitter : Twitter;
		private var tweets : Object;
		private var displayText : TextField;
		private var authorText : TextField;

		
		
		
		public function TwitterBadge() {
			start();
		}		

		//Creates the twitter object through which we'll get our tweets
		private function start() : void {
		
			// Associate the text field on the stage with our class's variable displayText and authorText
			displayText = TextField(getChildByName("display_txt"));	// display_txt on stage		
			authorText = TextField(getChildByName("author_txt")); // author_txt is on stage			
			
			// Create a new twitter object
			twitter = new Twitter();

			// Listen for a result when we ask for a user's tweets (next call)
			twitter.addEventListener(TwitterEvent.ON_USER_TIMELINE_RESULT, onUserTimelineResult);

			// Get a user's twitters
			twitter.loadUserTimeline(username);
		}



		// Fired when we have a result for the user timeline
		private function onUserTimelineResult(event : TwitterEvent) : void {
			tweets = event.data;
			showTweet();
		}


		//puts a tweet into the text field on stage.
		private function showTweet() : void {
			// Let's try to access the tweet at tweetIndex, but if it doesn't work... let's not let Flash throw a show-stopping error
			var tweetText : String;
			
			try {
				var cTweet : TwitterStatus = tweets[0];
				tweetText = cTweet.text;
			} catch (e : Error) {
				tweetText = "Oops. Looks like Twitter is down. Again.";
				trace("TwitterBadge.as: showTweet Error - The tweet index " + 0 + " does not exist inside of your array of tweets");
			}
			
			// Put text in
			displayText.text = tweetText;
			
			// Put author in
			authorText.text = (username + " is twittering on about this...");
			
		}
	}
}
